/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.CustomRegisters;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.item.INPCToolItem;
import noppes.npcs.client.ClientGuiEventHandler;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.IPermission;
import noppes.npcs.util.Util;

public class ItemNpcMovingPath
extends Item
implements IPermission,
INPCToolItem {
    public ItemNpcMovingPath() {
        this.setRegistryName("customnpcs", "npcmovingpath");
        this.func_77655_b("npcmovingpath");
        this.func_77664_n();
        this.field_77777_bU = 1;
        this.func_77637_a(CustomRegisters.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> list, @Nonnull ITooltipFlag flagIn) {
        list.add(new TextComponentTranslation("info.item.moving.path", new Object[0]).func_150254_d());
        for (int i = 0; i < 3; ++i) {
            if (i == 1 || i == 2) {
                list.add(new TextComponentTranslation("info.item.moving.path." + i, new Object[]{new TextComponentTranslation("ai.movingpath", new Object[0]).func_150254_d()}).func_150254_d());
                continue;
            }
            list.add(new TextComponentTranslation("info.item.moving.path." + i, new Object[0]).func_150254_d());
        }
    }

    private EntityNPCInterface getNpc(ItemStack item, World world) {
        if (world.field_72995_K || item.func_77978_p() == null) {
            return null;
        }
        Entity entity = world.func_73045_a(item.func_77978_p().func_74762_e("NPCID"));
        if (!(entity instanceof EntityNPCInterface)) {
            return null;
        }
        return (EntityNPCInterface)entity;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.MovingPathGet || e == EnumPacketServer.MovingPathSave;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(EnumHand.OFF_HAND));
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.TOOL_MOUNTER)) {
            EntityNPCInterface npc = this.getNpc(stack, world);
            if (npc != null && (player.func_70093_af() || npc.ais.getMovingType() == 2)) {
                NoppesUtilServer.sendOpenGui(player, EnumGuiType.MovingPath, npc);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos bpos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || !CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.TOOL_MOUNTER) || hand != EnumHand.MAIN_HAND) {
            if (world.field_72995_K) {
                ClientGuiEventHandler.movingPath.clear();
            }
            return EnumActionResult.FAIL;
        }
        Entity rayTraceEntity = Util.instance.getLookEntity((Entity)player, 4.0, false);
        if (rayTraceEntity instanceof EntityNPCInterface) {
            ((EntityNPCInterface)rayTraceEntity).func_70624_b(null);
            if (player.func_184614_ca().func_77978_p() == null || rayTraceEntity.func_145782_y() != player.func_184614_ca().func_77978_p().func_74762_e("NPCID")) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.pather.reg", new Object[]{rayTraceEntity.func_70005_c_(), player.func_184614_ca().func_82833_r()}));
            }
            player.func_184614_ca().func_77983_a("NPCID", (NBTBase)new NBTTagInt(rayTraceEntity.func_145782_y()));
            player.field_71070_bA.func_75142_b();
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.NPC_MOVING_PATH, rayTraceEntity.func_145782_y(), ((EntityNPCInterface)rayTraceEntity).ais.writeToNBT(new NBTTagCompound()));
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        EntityNPCInterface npc = this.getNpc(stack, world);
        if (npc == null) {
            return EnumActionResult.PASS;
        }
        List<int[]> list = npc.ais.getMovingPath();
        int[] pos = list.get(list.size() - 1);
        int x = bpos.func_177958_n();
        int y = bpos.func_177956_o();
        int z = bpos.func_177952_p();
        if (npc.ais.getMovingType() != 2) {
            npc.func_175449_a(new BlockPos(x, y, z), (int)npc.func_110174_bM());
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.pather.home", new Object[]{"\u00a76" + x, "\u00a76" + y, "\u00a76" + z, npc.func_70005_c_()}));
        } else {
            boolean added = true;
            if (!list.isEmpty()) {
                int[] p = list.get(list.size() - 1);
                boolean bl = added = p[0] != x || p[1] != y || p[2] != z;
            }
            if (added) {
                list.add(new int[]{x, y, z});
                double d0 = x - pos[0];
                double d1 = y - pos[1];
                double d3 = z - pos[2];
                double d4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d3 * d3));
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.pather.add", new Object[]{"\u00a76" + x, "\u00a76" + y, "\u00a76" + z, npc.func_70005_c_()}));
                if (d4 > (double)CustomNpcs.NpcNavRange) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.pather.warn.add", new Object[]{"\u00a76" + CustomNpcs.NpcNavRange}));
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

